#include <iostream>
#include <unordered_map>
#include <unordered_set>
#include <string> 
using namespace std;

int N, M, P, K;
unordered_map<string, int> memo;

string determineHash(int x, int y, int z) {
	return to_string(x) + "_" + to_string(y) + "_" + to_string(z);
}

int computeCurrentPrice(int x, int y, int z) {
	return (x * y * z + N + M + P) % K;
}

int determineShortestPath(int x, int y, int z) {
	if (x < 0 || y < 0 || z < 0) {
		return INT_MAX;
	}
	string hash = determineHash(x, y, z);
	if (memo.find(hash) != memo.end()) {
		return memo[hash];
	}

	auto opt1 = determineShortestPath(x - 1, y, z);
	auto opt2 = determineShortestPath(x, y - 1, z);
	auto opt3 = determineShortestPath(x, y, z - 1);
	int result= (min(opt1, min(opt2, opt3)) + computeCurrentPrice(x,y,z));
	memo[hash] = result;
	return result;
}
int main()
{
	cin >> N >> M >> P >> K;
	memo[determineHash(0, 0, 0)] = computeCurrentPrice(0, 0, 0);
	cout << determineShortestPath(N - 1, M - 1, P - 1);
}
